/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.util;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DelegatingServletInputStream
extends ServletInputStream {
    private final InputStream sourceStream;
    private boolean eof = false;

    public DelegatingServletInputStream(InputStream sourceStream) {
        this.sourceStream = sourceStream;
    }

    public int read() throws IOException {
        int read = this.sourceStream.read();
        if (read == -1) {
            this.eof = true;
        }
        return read;
    }

    public void close() throws IOException {
        super.close();
        this.sourceStream.close();
    }

    public boolean isFinished() {
        return this.eof;
    }

    public boolean isReady() {
        try {
            return this.eof || this.sourceStream.available() > 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setReadListener(ReadListener readListener) {
        throw new UnsupportedOperationException();
    }
}

