/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.status;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.content.render.image.ImageDimensions;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.plugins.status.StatusMacroConfiguration;
import com.atlassian.confluence.web.UrlBuilder;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.springframework.stereotype.Component;

@AnonymousSiteAccess
@Component
public class ImageGeneratorServlet
extends HttpServlet
implements EditorImagePlaceholder {
    private static final ImageDimensions IMAGE_DIMENSION = new ImageDimensions(88, 18);
    private static final String SERVLET_PATH = "/plugins/servlet/status-macro/placeholder";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StatusMacroConfiguration configuration = StatusMacroConfiguration.createFor(req.getParameterMap());
        Object text = configuration.getTitle();
        try (InputStream imageStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.filenameFor(configuration));){
            BufferedImage bufferedImage = ImageIO.read(imageStream);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Font font = new Font("Arial", 1, 22);
            graphics.setFont(font);
            graphics.setColor(configuration.getColour().forText(configuration.isSubtle()));
            int txtWidth = graphics.getFontMetrics().stringWidth((String)text);
            int txtHeight = graphics.getFontMetrics().getHeight();
            int imgWidth = bufferedImage.getWidth();
            int imgHeight = bufferedImage.getHeight();
            int horizontalPadding = 24;
            int ellipsisWidth = graphics.getFontMetrics().stringWidth("...");
            if (txtWidth + horizontalPadding > imgWidth) {
                Object newText = "";
                int pos = 0;
                while (graphics.getFontMetrics().stringWidth((String)newText) + ellipsisWidth + horizontalPadding <= imgWidth) {
                    newText = (String)newText + ((String)text).charAt(pos);
                    ++pos;
                }
                text = (String)newText + "...";
            }
            int yPos = imgHeight / 2 + txtHeight / 2 - graphics.getFontMetrics().getDescent();
            int xPos = imgWidth / 2 - graphics.getFontMetrics().stringWidth((String)text) / 2;
            graphics.drawString((String)text, xPos, yPos);
            resp.setContentType("image/png");
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)resp.getOutputStream());
        }
    }

    private String filenameFor(StatusMacroConfiguration configuration) {
        return "images/" + configuration.getColour().name().toLowerCase(Locale.ENGLISH) + (configuration.isSubtle() ? "-subtle" : "") + "@2x.png";
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> parameters, ConversionContext context) {
        return new DefaultImagePlaceholder(this.buildUrlToImage(parameters), false, IMAGE_DIMENSION);
    }

    private String buildUrlToImage(Map<String, String> parameters) {
        UrlBuilder builder = new UrlBuilder(SERVLET_PATH);
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            builder.add(parameter.getKey(), parameter.getValue());
        }
        return builder.toUrl();
    }
}

