/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.status;

import java.awt.Color;

public enum StatusColour {
    GREY(Color.WHITE, new Color(4478063)),
    GREEN(Color.WHITE, new Color(2065498), "aui-lozenge-success"),
    RED(Color.WHITE, new Color(13186860), "aui-lozenge-error"),
    YELLOW(new Color(1518413), new Color(10831872), "aui-lozenge-moved"),
    BLUE(Color.WHITE, new Color(812772), "aui-lozenge-current");

    public static final StatusColour DEFAULT;
    private final String cssClassName;
    private final Color defaultTextColor;
    private final Color subtleTextColor;

    private StatusColour(Color defaultTextColor, Color subtleTextColor) {
        this(defaultTextColor, subtleTextColor, null);
    }

    private StatusColour(Color defaultTextColor, Color subtleTextColor, String cssClassName) {
        this.defaultTextColor = defaultTextColor;
        this.subtleTextColor = subtleTextColor;
        this.cssClassName = cssClassName;
    }

    public Color forText(boolean subtle) {
        return subtle ? this.subtleTextColor : this.defaultTextColor;
    }

    public String correspondingLozengeCssClass() {
        return this.cssClassName;
    }

    public static StatusColour fromString(String name) {
        try {
            return StatusColour.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return DEFAULT;
        }
    }

    static {
        DEFAULT = GREY;
    }
}

