/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.atlassian.confluence.pages.Attachment;
import java.io.Serializable;
import java.util.Objects;

public class AttachmentCacheKey
implements Serializable {
    final long id;
    final int version;
    final String viewName;

    public AttachmentCacheKey(Attachment attachment, String viewName) {
        this.id = attachment.getId();
        this.version = attachment.getVersion();
        this.viewName = viewName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentCacheKey that = (AttachmentCacheKey)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        return Objects.equals(this.viewName, that.viewName);
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = 31 * result + this.version;
        result = 31 * result + (this.viewName != null ? this.viewName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("attachment-").append(this.id).append("-v").append(this.version);
        if (this.viewName != null) {
            sb.append('-').append(this.viewName);
        }
        return sb.toString();
    }
}

