/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.benryan.components.CustomCacheDirectorySetting;
import com.benryan.components.OcSettingsManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.Lazy;
import java.awt.Dimension;
import java.io.File;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ocSettingsManager")
public final class DefaultOcSettingsManager
implements OcSettingsManager {
    private final PluginSettings globalPluginSettings;
    private final ApplicationProperties applicationProperties;
    String customCacheDirectoriesFile = "resources/directories.properties";
    private final Supplier<CustomCacheDirectorySetting> customCacheDirectory;
    private static final Logger log = LoggerFactory.getLogger(DefaultOcSettingsManager.class);
    private static final int DEFAULT_MAX_CELL_LIMIT = 10000;

    @Autowired
    public DefaultOcSettingsManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ApplicationProperties applicationProperties) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.customCacheDirectory = Lazy.supplier(() -> new DefaultCustomCacheDirectorySetting(this.globalPluginSettings, this.customCacheDirectoriesFile));
        this.applicationProperties = applicationProperties;
    }

    public int getEditInWordLocation() {
        return this.getInteger("com.benryan.confluence.word.edit.location", 0);
    }

    public void setEditInWordLocation(int location) {
        this.setInteger("com.benryan.confluence.word.edit.location", location);
    }

    public boolean isShowWarning() {
        return this.getBoolean("com.benryan.confluence.word.edit.warning", false);
    }

    public void setShowWarning(boolean showWarning) {
        this.setBoolean("com.benryan.confluence.word.edit.warning", showWarning);
    }

    public boolean isDoFootnotes() {
        return this.getBoolean("com.benryan.confluence.word.edit.footnotes", false);
    }

    public void setDoFootnotes(boolean doFootnotes) {
        this.setBoolean("com.benryan.confluence.word.edit.footnotes", doFootnotes);
    }

    public CustomCacheDirectorySetting getCustomCacheDirectorySetting() {
        return this.customCacheDirectory.get();
    }

    public String getCacheDir() {
        if (this.getCacheType() == 1) {
            String cacheDir = this.customCacheDirectory.get().getDirectory();
            if (!StringUtils.isBlank((CharSequence)cacheDir)) {
                return cacheDir;
            }
            log.error("Custom cache directory blank or invalid. Defaulting to home directory.");
            return this.getHomeCachePath();
        }
        return this.getHomeCachePath();
    }

    public String getHomeCachePath() {
        return new File(this.applicationProperties.getHomeDirectory(), "viewfile").getAbsolutePath();
    }

    public int getCacheType() {
        return this.getInteger("com.benryan.confluence.word.edit.cacheType", 0);
    }

    public void setCacheType(int cacheType) {
        this.setInteger("com.benryan.confluence.word.edit.cacheType", cacheType);
    }

    public int getMaxQueues() {
        return this.getInteger("com.atlassian.confluence.officeconnector.maxQueues", 2);
    }

    public void setMaxQueues(int maxQueues) {
        this.setInteger("com.atlassian.confluence.officeconnector.maxQueues", maxQueues);
    }

    private int getInteger(String key, int fallback) {
        Integer value = (Integer)this.globalPluginSettings.get(key);
        return value != null ? value : fallback;
    }

    void setInteger(String key, int value) {
        this.globalPluginSettings.put(key, (Object)value);
    }

    private boolean getBoolean(String key, boolean fallback) {
        Boolean val = (Boolean)this.globalPluginSettings.get(key);
        return val != null ? val : fallback;
    }

    void setBoolean(String key, boolean value) {
        this.globalPluginSettings.put(key, (Object)value);
    }

    String getString(String key) {
        return (String)this.globalPluginSettings.get(key);
    }

    void setString(String key, String value) {
        this.globalPluginSettings.put(key, (Object)value);
    }

    public int getMaxCacheSize() {
        return this.getInteger("com.atlassian.confluence.officeconnector.maxCacheSize", 500);
    }

    public void setMaxCacheSize(int size) {
        this.setInteger("com.atlassian.confluence.officeconnector.maxCacheSize", size);
    }

    public boolean getPathAuth() {
        return this.getBoolean("com.atlassian.confluence.officeconnector.usePathAuth", false);
    }

    public void setPathAuth(boolean pathAuth) {
        this.setBoolean("com.atlassian.confluence.officeconnector.usePathAuth", pathAuth);
    }

    public Dimension getMaxImportImageSize() {
        int height = this.getInteger("com.atlassian.confluence.officeconnector.maxImageHeight", 1200);
        int width = this.getInteger("com.atlassian.confluence.officeconnector.maxImageWidth", 900);
        return new Dimension(width, height);
    }

    public void setMaxImportImageSize(Dimension dimension) {
        this.setInteger("com.atlassian.confluence.officeconnector.maxImageHeight", dimension.height);
        this.setInteger("com.atlassian.confluence.officeconnector.maxImageWidth", dimension.width);
    }

    @VisibleForTesting
    void setCustomCacheDirectoriesFile(String customCacheDirectoriesFile) {
        this.customCacheDirectoriesFile = customCacheDirectoriesFile;
    }

    public static class DefaultCustomCacheDirectorySetting
    implements CustomCacheDirectorySetting {
        private String directory;
        private String error = "";
        private boolean isPluginSettings = false;
        private final PluginSettings globalPluginSettings;

        public DefaultCustomCacheDirectorySetting(PluginSettings globalPluginSettings, String cacheDirectoriesFile) {
            this.globalPluginSettings = globalPluginSettings;
            ImmutableMap errors = ImmutableMap.builder().put((Object)"office.connector.config.caching.error.general", (Object)"An error occurred while reading the properties file.").put((Object)"office.connector.config.caching.error.blank", (Object)"No directory specified in the properties file.").put((Object)"office.connector.config.caching.error.no.directory", (Object)"The specified cache directory doesn't exist.").put((Object)"office.connector.config.caching.error.not.a.directory", (Object)"The specified cache file is not a directory.").put((Object)"office.connector.config.caching.error.cannot.write", (Object)"Can't write to the specified cache directory. Please check the permissions.").put((Object)"office.connector.config.caching.error.cannot.read", (Object)"Can't read from the specified cache directory. Please check the permissions.").put((Object)"office.connector.config.caching.error.reading.directory", (Object)"Error reading custom cache directory.").build();
            try {
                Properties directories = new Properties();
                directories.load(ClassLoaderUtils.getResourceAsStream((String)cacheDirectoriesFile, DefaultOcSettingsManager.class));
                this.directory = directories.getProperty("com.benryan.confluence.word.edit.cacheDir");
            }
            catch (Exception e) {
                this.directory = null;
                this.error = "office.connector.config.caching.error.general";
                log.error((String)errors.get(this.error), (Throwable)e);
            }
            if (StringUtils.isBlank((CharSequence)this.directory) && StringUtils.isBlank((CharSequence)this.error)) {
                this.setPluginSettingsCache();
            }
            if (!StringUtils.isBlank((CharSequence)this.directory) && StringUtils.isBlank((CharSequence)this.error)) {
                this.error = this.validateDirectory(this.directory);
            }
            if (this.directory != null && this.error != null && this.directory.isEmpty() && this.error.isEmpty()) {
                this.directory = null;
                this.error = "office.connector.config.caching.error.blank";
            }
            if (!StringUtils.isBlank((CharSequence)this.error)) {
                log.error((String)errors.get(this.error));
                this.directory = null;
            }
        }

        private String validateDirectory(String directory) {
            log.info("Validating");
            try {
                File f = new File(directory);
                if (!f.exists()) {
                    return "office.connector.config.caching.error.no.directory";
                }
                if (!f.isDirectory()) {
                    return "office.connector.config.caching.error.not.a.directory";
                }
                if (!f.canWrite()) {
                    return "office.connector.config.caching.error.cannot.write";
                }
                if (!f.canRead()) {
                    return "office.connector.config.caching.error.cannot.read";
                }
            }
            catch (Exception e) {
                return "office.connector.config.caching.error.reading.directory";
            }
            return null;
        }

        public void setPluginSettingsCache() {
            String pluginSettingsCacheDir = this.getString("com.benryan.confluence.word.edit.cacheDir");
            if (!StringUtils.isBlank((CharSequence)pluginSettingsCacheDir)) {
                this.directory = pluginSettingsCacheDir;
                this.isPluginSettings = true;
            }
        }

        private String getString(String key) {
            return (String)this.globalPluginSettings.get(key);
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getError() {
            return this.error;
        }

        public boolean isPluginSettings() {
            return this.isPluginSettings;
        }
    }
}

