/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.plugins.conversion.convert.FileFormat;
import com.atlassian.plugins.conversion.convert.html.HtmlConversionData;
import com.benryan.conversion.ConversionCache;
import com.benryan.conversion.SafeFileObjectInputStream;
import com.benryan.conversion.SlideDocConversionData;
import com.benryan.conversion.SlidePageConversionData;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import io.atlassian.util.concurrent.ConcurrentOperationMap;
import io.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedCache
implements ConversionCache {
    private static final Logger log = LoggerFactory.getLogger(FileBackedCache.class);
    private final ConcurrentOperationMap<String, Object> operationMap = new ConcurrentOperationMapImpl();
    private final File _cacheDir;
    private static final String PATH_NOT_EXIST_ERROR = "The specified path: %s doesn't exist and we are unable to create it.";
    private static final String NO_ACCESS_ERROR = "Confluence doesn't have read/write access to the specified cache directory: %s.";
    private final Set<Class<?>> allowedClasses;
    private final boolean fileDeserializeAllowlistEnabled = System.getProperty("officeconnector.deserialization.allowlist.enabled") == null || Boolean.getBoolean("officeconnector.deserialization.allowlist.enabled");
    static final String FILE_DESERIALIZE_ALLOWLIST_ENABLED_PROPERTY = "officeconnector.deserialization.allowlist.enabled";
    static final String ADDITIONAL_ALLOWED_CLASSES_PROPERTY = "officeconnector.deserialization.classes.allowlist";
    private static final Set<Class<?>> ALLOWED_CLASSES = Set.of(ArrayList.class, Boolean.class, Byte.class, Character.class, Date.class, Double.class, Enum.class, FileFormat.class, Float.class, HashMap.class, HashSet.class, Integer.class, LinkedHashMap.class, LinkedHashSet.class, LinkedList.class, Long.class, FileBackedCache.runtimeClass("java.util.Collections$UnmodifiableMap"), Short.class, SlideDocConversionData.class, SlidePageConversionData.class, String.class, UUID.class, HtmlConversionData.class, FileBackedCache.runtimeClass("[B"), FileBackedCache.runtimeClass("[S"), FileBackedCache.runtimeClass("[I"), FileBackedCache.runtimeClass("[J"), FileBackedCache.runtimeClass("[F"), FileBackedCache.runtimeClass("[D"), FileBackedCache.runtimeClass("[C"), FileBackedCache.runtimeClass("[Z"));

    public FileBackedCache(String path) throws IOException {
        this(path, ALLOWED_CLASSES);
    }

    public FileBackedCache(String path, Set<Class<?>> allowedClasses) throws IOException {
        this._cacheDir = new File(path);
        if (!this._cacheDir.exists() && !this._cacheDir.mkdirs()) {
            throw new IOException(String.format(PATH_NOT_EXIST_ERROR, path));
        }
        if (!this._cacheDir.canRead() || !this._cacheDir.canWrite()) {
            throw new IOException(String.format(NO_ACCESS_ERROR, path));
        }
        this.allowedClasses = Sets.union(allowedClasses, FileBackedCache.getAdditionalAllowedClasses());
    }

    private static Set<Class<?>> getAdditionalAllowedClasses() {
        HashSet additionalClasses = new HashSet();
        String additionalClassesProperty = System.getProperty(ADDITIONAL_ALLOWED_CLASSES_PROPERTY);
        if (!StringUtils.isBlank((CharSequence)additionalClassesProperty)) {
            String[] classNames;
            for (String className : classNames = additionalClassesProperty.split(",")) {
                try {
                    Class<?> clazz = Class.forName(className.trim());
                    additionalClasses.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn("Class not found for additional allowed class: " + className, (Throwable)e);
                }
            }
        }
        return additionalClasses;
    }

    private static Class<?> runtimeClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object get(Object key) {
        String name = this.sanitizeFilename(key.toString());
        try {
            return this.operationMap.runOperation((Object)name, () -> this.loadFile(name));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private Object loadFile(String name) {
        Object inObj = null;
        File child = new File(this._cacheDir, name);
        if (child.exists() && child.canRead()) {
            try (FileInputStream fileIn = new FileInputStream(child);
                 BufferedInputStream bufferIn = new BufferedInputStream(fileIn);
                 ObjectInputStream in = this.fileDeserializeAllowlistEnabled ? new SafeFileObjectInputStream(bufferIn, this.allowedClasses) : new ObjectInputStream(bufferIn);){
                inObj = in.readObject();
            }
            catch (Exception e) {
                log.warn("Failed to read file " + String.valueOf(child) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return inObj;
    }

    @Override
    public void put(Object key, Object val) {
        String name = this.sanitizeFilename(key.toString());
        if (val instanceof Serializable) {
            File file = new File(this._cacheDir, name);
            File tmpFile = new File(this._cacheDir, name + ".part");
            try (FileOutputStream fileOut = new FileOutputStream(tmpFile);
                 BufferedOutputStream bufferOut = new BufferedOutputStream(fileOut);
                 ObjectOutputStream out = new ObjectOutputStream(bufferOut);){
                out.writeObject(val);
            }
            catch (Exception e) {
                log.warn("Failed to write file " + String.valueOf(file) + ": " + e.getMessage(), (Throwable)e);
            }
            try {
                if (file.exists()) {
                    file.delete();
                }
                FileUtils.moveFile((File)tmpFile, (File)file);
            }
            catch (IOException e) {
                log.warn("Failed to rename file " + String.valueOf(tmpFile) + " to " + String.valueOf(file) + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String sanitizeFilename(String name) {
        String sanitized = name.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        if ((sanitized = sanitized.replace("/", "_").replace("\\", "_")).length() > 255) {
            sanitized = sanitized.substring(0, 255);
        }
        return sanitized;
    }
}

