/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.confluence.util.sandbox.Sandbox;
import com.atlassian.confluence.util.sandbox.SandboxRegistry;
import com.atlassian.confluence.util.sandbox.SandboxSpec;
import com.atlassian.confluence.util.sandbox.SandboxTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.time.Duration;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="officeConnectorConversionSandbox")
public class OfficeConnectorConversionSandbox
implements Sandbox {
    private static final int MEMORY_LIMIT_MEGABYTES = Integer.getInteger("document.conversion.sandbox.memory.requirement.megabytes", 128);
    private static final int REQUEST_TIME_LIMIT_SECS = Integer.getInteger("document.conversion.sandbox.request.time.limit.secs", 30);
    private final Sandbox delegate;

    @Autowired
    public OfficeConnectorConversionSandbox(@ComponentImport SandboxRegistry sandboxRegistry) {
        this.delegate = Objects.requireNonNull(sandboxRegistry).get(SandboxSpec.builder().withMinimumMemoryInMb(MEMORY_LIMIT_MEGABYTES).build(Duration.ofSeconds(REQUEST_TIME_LIMIT_SECS)));
    }

    public <T, R> R execute(SandboxTask<T, R> sandboxTask, T input) {
        return this.execute(sandboxTask, input, Duration.ofSeconds(REQUEST_TIME_LIMIT_SECS));
    }

    public <T, R> R execute(SandboxTask<T, R> sandboxTask, T input, Duration timeLimit) {
        return (R)this.delegate.execute(sandboxTask, input, timeLimit);
    }
}

