/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SafeFileObjectInputStream
extends ObjectInputStream {
    private final Set<String> allowedClassNames;

    public SafeFileObjectInputStream(InputStream in, Set<Class<?>> allowedClasses) throws IOException {
        super(in);
        this.allowedClassNames = allowedClasses.stream().map(Class::getName).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (!this.isClassNameAllowedForDeserialization(className)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", className);
        }
        return super.resolveClass(desc);
    }

    private boolean isClassNameAllowedForDeserialization(String className) {
        return this.allowedClassNames.contains(className) || this.isObjectArrayTypeAllowedForDeserialization(className);
    }

    private boolean isObjectArrayTypeAllowedForDeserialization(String className) {
        if (!StringUtils.isBlank((CharSequence)className) && className.startsWith("[L") && className.length() > 2) {
            String componentType = className.substring(2, className.length() - 1);
            return this.allowedClassNames.contains(componentType);
        }
        return false;
    }
}

