/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import com.benryan.conversion.Converter;
import com.benryan.conversion.ConverterFactory;
import com.benryan.conversion.ConverterHelper;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Path(value="view")
@Produces(value={"application/json"})
public class ConverterMacroResource {
    private static final Logger log = LoggerFactory.getLogger(ConverterMacroResource.class);
    private final AttachmentManager attachmentManager;
    private final ContentEntityManager contentEntityManager;
    private final ConverterFactory converterFactory;
    private final ConverterHelper converterHelper;

    @Inject
    public ConverterMacroResource(@ComponentImport AttachmentManager attachmentManager, @ComponentImport @Named(value="contentEntityManager") ContentEntityManager contentEntityManager, ConverterFactory converterFactory, ConverterHelper converterHelper) {
        this.attachmentManager = attachmentManager;
        this.contentEntityManager = contentEntityManager;
        this.converterFactory = converterFactory;
        this.converterHelper = converterHelper;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getContent(@Context UriInfo uriInfo, @QueryParam(value="pageID") Long pageId, @QueryParam(value="name") String name) {
        ContentEntityObject page = this.contentEntityManager.getById(pageId.longValue());
        Attachment attachment = this.attachmentManager.getAttachment(page, name);
        if (null == page || null == attachment) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            Map queryParameters = Maps.transformValues((Map)uriInfo.getQueryParameters(), entry -> entry != null ? (String)entry.get(0) : null);
            Map<String, Object> arguments = this.converterHelper.validateArguments(queryParameters, (ConversionContext)new DefaultConversionContext((RenderContext)new PageContext(page)));
            Converter converter = this.converterFactory.create((String)queryParameters.get("type"));
            String content = converter.execute(arguments);
            return Response.ok(Collections.singletonMap("content", content)).build();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("attachmentId", attachment.getId());
            data.put("downloadUrl", this.attachmentManager.getAttachmentDownloadPath(page, name));
            data.put("fileName", attachment.getFileName());
            data.put("pageId", page.getContentId());
            return Response.status((int)422).entity(data).build();
        }
    }
}

