/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import com.benryan.components.OcSettingsManager;
import com.benryan.conversion.WebDavUtil;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;

@UnlicensedSiteAccess
@Produces(value={"application/json"})
@Path(value="metadata")
public class EditInOfficeResource {
    private final AttachmentManager attachmentManager;
    private final OcSettingsManager ocSettings;

    @Inject
    public EditInOfficeResource(@ComponentImport AttachmentManager attachmentManager, OcSettingsManager ocSettings) {
        this.attachmentManager = attachmentManager;
        this.ocSettings = ocSettings;
    }

    @GET
    @Path(value="/{attachmentId}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getEditInOfficeMetadata(@PathParam(value="attachmentId") long attachmentId) {
        HashMap metadata = Maps.newHashMap();
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        WebDavUtil webDavUtil = new WebDavUtil((AbstractPage)attachment.getContainer());
        String webDavUrl = webDavUtil.getRelWebDavUrl(attachment.getFileName());
        boolean pathAuth = this.ocSettings.getPathAuth();
        metadata.put("webDavUrl", webDavUrl);
        metadata.put("usePathAuth", pathAuth);
        return Response.ok((Object)metadata).build();
    }
}

