/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.benryan.components.TemporaryAuthTokenManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;

@Path(value="authtoken")
@Produces(value={"application/json"})
public class TemporaryTokenResource {
    private final TemporaryAuthTokenManager authTokenManager;

    @Inject
    public TemporaryTokenResource(TemporaryAuthTokenManager manager) {
        this.authTokenManager = manager;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getAuthTokenForCurrentUserSession() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            String token = this.authTokenManager.createToken((User)user);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", token);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            cacheControl.setMustRevalidate(true);
            cacheControl.setProxyRevalidate(true);
            cacheControl.setMaxAge(0);
            cacheControl.setPrivate(true);
            return Response.ok(map).cacheControl(cacheControl).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

