/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.EntityException;
import com.benryan.components.TemporaryAuthTokenManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;

@UnrestrictedAccess
public class PathAuthenticator
implements Filter {
    private final TemporaryAuthTokenManager tokenManager;

    public PathAuthenticator(TemporaryAuthTokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        String[] path = this.splitPath(httpReq);
        for (int x = 0; x < path.length; ++x) {
            int y;
            if (!path[x].equalsIgnoreCase("ocauth") || x >= path.length - 1) continue;
            String token = path[x + 1];
            StringBuilder redirect = new StringBuilder();
            for (y = 0; y < x; ++y) {
                if (path[y].trim().isEmpty()) continue;
                redirect.append('/');
                redirect.append(path[y]);
            }
            for (y = x + 2; y < path.length; ++y) {
                if (path[y].trim().isEmpty()) continue;
                redirect.append('/');
                redirect.append(path[y]);
            }
            try {
                ConfluenceUser user = this.tokenManager.getUser(token);
                if (user != null) {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
                }
            }
            catch (EntityException entityException) {
                // empty catch block
            }
            chain.doFilter((ServletRequest)new OcAuthRequestWrapper((HttpServletRequest)req, ((HttpServletRequest)req).getContextPath() + String.valueOf(redirect)), res);
            return;
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private String[] splitPath(HttpServletRequest req) {
        String ctx;
        String path = req.getRequestURI();
        if (path.startsWith(ctx = req.getContextPath())) {
            path = path.substring(ctx.length());
        }
        return path.split("/");
    }

    private class OcAuthRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newUri;

        public OcAuthRequestWrapper(HttpServletRequest request, String newUri) {
            super(request);
            this.newUri = newUri;
        }

        public String getRequestURI() {
            return this.newUri;
        }
    }
}

