/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.servlet.webdav;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.extra.webdav.resource.AbstractAttachmentResource;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.download.SafeContentHeaderGuesser;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.util.FileTypeUtil;
import com.benryan.servlet.webdav.ResourceBuilder;
import java.io.InputStream;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentResource
extends AbstractAttachmentResource {
    public static final String PATH_PREFIX = "attachments";
    private static final Logger log = LoggerFactory.getLogger(AttachmentResource.class);
    private final FileUploadManager fileUploadManager;
    private final Attachment attachment;
    private final PermissionManager permissionManager;
    private final ContentEntityObject content;
    private final String attachmentName;

    AttachmentResource(ResourceBuilder builder, @ComponentImport PermissionManager permissionManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport SafeContentHeaderGuesser attachmentSafeContentHeaderGuesser, ContentEntityObject content, String attachmentName) {
        super(builder.getDavResourceLocator(), builder.getDavResourceFactory(), builder.getLockManager(), builder.getDavSession(), attachmentSafeContentHeaderGuesser, attachmentManager, attachmentName, builder.getDavSession().getUserAgent());
        this.permissionManager = permissionManager;
        this.fileUploadManager = builder.getFileUploadManager();
        this.content = content;
        this.attachmentName = attachmentName;
        this.attachment = this.getAttachment();
    }

    private static String chooseContentType(InputContext inputContext, String attachmentName) {
        String contentTypeFromRequest = inputContext.getContentType();
        String contentTypeFromExtension = FileTypeUtil.getContentType((String)attachmentName);
        log.debug("Content Type from request: {}, Content Type from file type : {}", (Object)contentTypeFromRequest, (Object)contentTypeFromExtension);
        log.debug("Resulting type: {}", (Object)contentTypeFromExtension);
        return contentTypeFromExtension;
    }

    public boolean exists() {
        return this.attachment != null;
    }

    public long getModificationTime() {
        return this.attachment.getLastModificationDate().getTime();
    }

    public InputStream getContent() {
        return this.getAttachmentManager().getAttachmentData(this.attachment);
    }

    protected long getContentLength() {
        return this.attachment.getFileSize();
    }

    protected String getContentType() {
        return this.attachment.getMediaType();
    }

    protected long getCreationtTime() {
        return this.attachment.getCreationDate().getTime();
    }

    public String getDisplayName() {
        return this.attachment.getFileName();
    }

    public ContentEntityObject getContentEntityObject() {
        return this.content;
    }

    public void saveData(InputContext inputContext) throws DavException {
        this.checkEditPermission();
        try {
            String contentType = AttachmentResource.chooseContentType(inputContext, this.attachmentName);
            InputStreamAttachmentResource uploaderResource = new InputStreamAttachmentResource(inputContext.getInputStream(), this.attachmentName, contentType, inputContext.getContentLength(), this.attachment.getVersionComment());
            this.fileUploadManager.storeResource((com.atlassian.confluence.core.AttachmentResource)uploaderResource, this.content);
        }
        catch (Exception e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public void checkEditPermission() throws DavException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, (Object)this.attachment)) {
            throw new DavException(401, "You do not have permission to edit the attachment " + this.attachment.getFileName());
        }
    }
}

