/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta;

import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterChainAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterConfigAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletConfigAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletContextAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletContextListenerAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletRequestAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletResponseAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletRequestAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletResponseAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpSessionAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpServletRequest;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class JakartaAdapters {
    private JakartaAdapters() {
    }

    public static Object asJakartaIfJavaX(Object delegate) {
        if (delegate instanceof ServletRequest) {
            ServletRequest cast = (ServletRequest)delegate;
            return JakartaAdapters.asJakarta(cast);
        }
        if (delegate instanceof ServletResponse) {
            ServletResponse cast = (ServletResponse)delegate;
            return JakartaAdapters.asJakarta(cast);
        }
        if (delegate instanceof javax.servlet.ServletContext) {
            javax.servlet.ServletContext cast = (javax.servlet.ServletContext)delegate;
            return JakartaAdapters.asJakarta(cast);
        }
        if (delegate instanceof Servlet) {
            Servlet cast = (Servlet)delegate;
            return JakartaAdapters.asJakarta(cast);
        }
        if (delegate instanceof javax.servlet.Filter) {
            javax.servlet.Filter cast = (javax.servlet.Filter)delegate;
            return JakartaAdapters.asJakarta(cast);
        }
        if (delegate instanceof HttpSession) {
            HttpSession cast = (HttpSession)delegate;
            return JakartaAdapters.asJakarta(cast);
        }
        return delegate;
    }

    public static Filter asJakarta(javax.servlet.Filter delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaFilterAdapter::from);
    }

    public static FilterChain asJakarta(javax.servlet.FilterChain delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaFilterChainAdapter::from);
    }

    public static jakarta.servlet.FilterConfig asJakarta(FilterConfig delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaFilterConfigAdapter::from);
    }

    public static jakarta.servlet.Servlet asJakarta(Servlet delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletAdapter::from);
    }

    public static jakarta.servlet.ServletConfig asJakarta(ServletConfig delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletConfigAdapter::from);
    }

    public static jakarta.servlet.http.HttpSession asJakarta(HttpSession delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaHttpSessionAdapter::from);
    }

    public static HttpServletRequest asJakarta(javax.servlet.http.HttpServletRequest delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaHttpServletRequestAdapter::from);
    }

    public static jakarta.servlet.ServletRequest asJakarta(ServletRequest delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletRequestAdapter::from);
    }

    public static jakarta.servlet.http.HttpServletResponse asJakarta(HttpServletResponse delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaHttpServletResponseAdapter::from);
    }

    public static jakarta.servlet.ServletResponse asJakarta(ServletResponse delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletResponseAdapter::from);
    }

    public static ServletContext asJakarta(javax.servlet.ServletContext delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletContextAdapter::from);
    }

    public static ServletContextListener asJakarta(javax.servlet.ServletContextListener delegate) {
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletContextListenerAdapter::from);
    }
}

