/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.el;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.javax.el.JavaXImportHandlerAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.el.ELException;
import java.util.Objects;
import javax.el.ImportHandler;

public class JakartaImportHandlerAdapter
extends jakarta.el.ImportHandler
implements Adapted<ImportHandler> {
    private final ImportHandler delegate;

    public static jakarta.el.ImportHandler from(ImportHandler delegate) {
        if (delegate instanceof JavaXImportHandlerAdapter) {
            JavaXImportHandlerAdapter castDelegate = (JavaXImportHandlerAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaImportHandlerAdapter::new);
    }

    protected JakartaImportHandlerAdapter(ImportHandler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ImportHandler getDelegate() {
        return this.delegate;
    }

    public void importStatic(String name) throws ELException {
        this.delegate.importStatic(name);
    }

    public void importClass(String name) throws ELException {
        this.delegate.importClass(name);
    }

    public void importPackage(String packageName) {
        if (this.delegate == null) {
            return;
        }
        this.delegate.importPackage(packageName);
    }

    public Class<?> resolveClass(String name) {
        return this.delegate.resolveClass(name);
    }

    public Class<?> resolveStatic(String name) {
        return this.delegate.resolveStatic(name);
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

