/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXAsyncContextAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXAsyncListenerAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.Objects;
import javax.servlet.ServletException;

public class JakartaAsyncContextAdapter
implements AsyncContext,
Adapted<javax.servlet.AsyncContext> {
    private final javax.servlet.AsyncContext delegate;

    public static AsyncContext from(javax.servlet.AsyncContext delegate) {
        if (delegate instanceof JavaXAsyncContextAdapter) {
            JavaXAsyncContextAdapter castDelegate = (JavaXAsyncContextAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaAsyncContextAdapter::new);
    }

    protected JakartaAsyncContextAdapter(javax.servlet.AsyncContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.AsyncContext getDelegate() {
        return this.delegate;
    }

    public ServletRequest getRequest() {
        return JakartaAdapters.asJakarta(this.delegate.getRequest());
    }

    public ServletResponse getResponse() {
        return JakartaAdapters.asJakarta(this.delegate.getResponse());
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.delegate.hasOriginalRequestAndResponse();
    }

    public void dispatch() {
        this.delegate.dispatch();
    }

    public void dispatch(String path) {
        this.delegate.dispatch(path);
    }

    public void dispatch(ServletContext context, String path) {
        this.delegate.dispatch(JavaXAdapters.asJavaX(context), path);
    }

    public void complete() {
        this.delegate.complete();
    }

    public void start(Runnable run) {
        this.delegate.start(run);
    }

    public void addListener(AsyncListener listener) {
        this.delegate.addListener(JavaXAsyncListenerAdapter.from(listener));
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.delegate.addListener(JavaXAsyncListenerAdapter.from(listener), JavaXAdapters.asJavaX(servletRequest), JavaXAdapters.asJavaX(servletResponse));
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)((AsyncListener)this.delegate.createListener(clazz));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void setTimeout(long timeout) {
        this.delegate.setTimeout(timeout);
    }

    public long getTimeout() {
        return this.delegate.getTimeout();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

