/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaAsyncContextAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXAsyncEventAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.Objects;
import javax.servlet.AsyncEvent;

public class JakartaAsyncEventAdapter
extends jakarta.servlet.AsyncEvent
implements Adapted<AsyncEvent> {
    private final AsyncEvent delegate;

    public static jakarta.servlet.AsyncEvent from(AsyncEvent delegate) {
        if (delegate instanceof JavaXAsyncEventAdapter) {
            JavaXAsyncEventAdapter castDelegate = (JavaXAsyncEventAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaAsyncEventAdapter::new);
    }

    protected JakartaAsyncEventAdapter(AsyncEvent delegate) {
        super(null, null, null);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public AsyncEvent getDelegate() {
        return this.delegate;
    }

    public AsyncContext getAsyncContext() {
        return JakartaAsyncContextAdapter.from(this.delegate.getAsyncContext());
    }

    public ServletRequest getSuppliedRequest() {
        return JakartaAdapters.asJakarta(this.delegate.getSuppliedRequest());
    }

    public ServletResponse getSuppliedResponse() {
        return JakartaAdapters.asJakarta(this.delegate.getSuppliedResponse());
    }

    public Throwable getThrowable() {
        return this.delegate.getThrowable();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

