/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.servlet.JakartaGenericFilterAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterChainAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterConfigAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.GenericFilter;
import javax.servlet.ServletException;

public class JakartaFilterAdapter
implements Filter,
Adapted<javax.servlet.Filter> {
    private final javax.servlet.Filter delegate;

    public static Filter from(javax.servlet.Filter delegate) {
        if (delegate instanceof GenericFilter) {
            GenericFilter castDelegate = (GenericFilter)delegate;
            return JakartaGenericFilterAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXFilterAdapter) {
            JavaXFilterAdapter castDelegate = (JavaXFilterAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaFilterAdapter::new);
    }

    protected JakartaFilterAdapter(javax.servlet.Filter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.Filter getDelegate() {
        return this.delegate;
    }

    public void init(FilterConfig filterConfig) throws jakarta.servlet.ServletException {
        try {
            this.delegate.init(JavaXFilterConfigAdapter.from(filterConfig));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, jakarta.servlet.ServletException {
        try {
            this.delegate.doFilter(JavaXAdapters.asJavaX(servletRequest), JavaXAdapters.asJavaX(servletResponse), JavaXFilterChainAdapter.from(filterChain));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

