/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterConfigAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Objects;

public class JakartaFilterConfigAdapter
implements FilterConfig,
Adapted<javax.servlet.FilterConfig> {
    private final javax.servlet.FilterConfig delegate;

    public static FilterConfig from(javax.servlet.FilterConfig delegate) {
        if (delegate instanceof JavaXFilterConfigAdapter) {
            JavaXFilterConfigAdapter castDelegate = (JavaXFilterConfigAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaFilterConfigAdapter::new);
    }

    protected JakartaFilterConfigAdapter(javax.servlet.FilterConfig delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.FilterConfig getDelegate() {
        return this.delegate;
    }

    public String getFilterName() {
        return this.delegate.getFilterName();
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

