/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.jakarta.servlet.JakartaDynamicFilterRegistrationAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterRegistrationAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.DispatcherType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import javax.servlet.FilterRegistration;
import javax.servlet.Registration;

public class JakartaFilterRegistrationAdapter
extends JakartaRegistrationAdapter
implements jakarta.servlet.FilterRegistration {
    private final FilterRegistration delegate;

    public static jakarta.servlet.FilterRegistration from(FilterRegistration delegate) {
        if (delegate instanceof FilterRegistration.Dynamic) {
            FilterRegistration.Dynamic castDelegate = (FilterRegistration.Dynamic)delegate;
            return JakartaDynamicFilterRegistrationAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXFilterRegistrationAdapter) {
            JavaXFilterRegistrationAdapter castDelegate = (JavaXFilterRegistrationAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaFilterRegistrationAdapter::new);
    }

    protected JakartaFilterRegistrationAdapter(FilterRegistration delegate) {
        super((Registration)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public FilterRegistration getDelegate() {
        return this.delegate;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.delegate.addMappingForServletNames(JakartaFilterRegistrationAdapter.toJavaXDispatcherTypeSet(dispatcherTypes), isMatchAfter, servletNames);
    }

    public Collection<String> getServletNameMappings() {
        return this.delegate.getServletNameMappings();
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.delegate.addMappingForUrlPatterns(JakartaFilterRegistrationAdapter.toJavaXDispatcherTypeSet(dispatcherTypes), isMatchAfter, urlPatterns);
    }

    public Collection<String> getUrlPatternMappings() {
        return this.delegate.getUrlPatternMappings();
    }

    private static EnumSet<javax.servlet.DispatcherType> toJavaXDispatcherTypeSet(Collection<DispatcherType> dispatcherTypes) {
        if (dispatcherTypes == null) {
            return null;
        }
        EnumSet<javax.servlet.DispatcherType> result = EnumSet.noneOf(javax.servlet.DispatcherType.class);
        for (DispatcherType dispatcherType : dispatcherTypes) {
            result.add(javax.servlet.DispatcherType.valueOf((String)dispatcherType.name()));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    @Override
    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

