/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpFilterAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXGenericFilterAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.GenericFilter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpFilter;

public class JakartaGenericFilterAdapter
extends jakarta.servlet.GenericFilter
implements Adapted<GenericFilter> {
    private final GenericFilter delegate;

    public static jakarta.servlet.GenericFilter from(GenericFilter delegate) {
        if (delegate instanceof HttpFilter) {
            HttpFilter castDelegate = (HttpFilter)delegate;
            return JakartaHttpFilterAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXGenericFilterAdapter) {
            JavaXGenericFilterAdapter castDelegate = (JavaXGenericFilterAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaGenericFilterAdapter::new);
    }

    protected JakartaGenericFilterAdapter(GenericFilter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public GenericFilter getDelegate() {
        return this.delegate;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, jakarta.servlet.ServletException {
        try {
            this.delegate.doFilter(JavaXAdapters.asJavaX(req), JavaXAdapters.asJavaX(res), JavaXAdapters.asJavaX(chain));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public FilterConfig getFilterConfig() {
        return JakartaAdapters.asJakarta(this.delegate.getFilterConfig());
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public void init(FilterConfig config) throws jakarta.servlet.ServletException {
        try {
            this.delegate.init(JavaXAdapters.asJavaX(config));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void init() throws jakarta.servlet.ServletException {
        try {
            this.delegate.init();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getFilterName() {
        return this.delegate.getFilterName();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

