/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXGenericServletAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class JakartaGenericServletAdapter
extends GenericServlet
implements Adapted<javax.servlet.GenericServlet> {
    private final javax.servlet.GenericServlet delegate;

    public static GenericServlet from(javax.servlet.GenericServlet delegate) {
        if (delegate instanceof HttpServlet) {
            HttpServlet castDelegate = (HttpServlet)delegate;
            return JakartaHttpServletAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXGenericServletAdapter) {
            JavaXGenericServletAdapter castDelegate = (JavaXGenericServletAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaGenericServletAdapter::new);
    }

    protected JakartaGenericServletAdapter(javax.servlet.GenericServlet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.GenericServlet getDelegate() {
        return this.delegate;
    }

    public void service(ServletRequest req, ServletResponse res) throws jakarta.servlet.ServletException, IOException {
        try {
            this.delegate.service(JavaXAdapters.asJavaX(req), JavaXAdapters.asJavaX(res));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getServletName() {
        return this.delegate.getServletName();
    }

    public void log(String message, Throwable t) {
        this.delegate.log(message, t);
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void init() throws jakarta.servlet.ServletException {
        try {
            this.delegate.init();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig config) throws jakarta.servlet.ServletException {
        try {
            this.delegate.init(JavaXAdapters.asJavaX(config));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public ServletConfig getServletConfig() {
        return JakartaAdapters.asJakarta(this.delegate.getServletConfig());
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

