/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterRegistrationAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXRegistrationAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.Registration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletRegistration;

public class JakartaRegistrationAdapter
implements Registration,
Adapted<javax.servlet.Registration> {
    private final javax.servlet.Registration delegate;

    public static Registration from(javax.servlet.Registration delegate) {
        if (delegate instanceof ServletRegistration) {
            ServletRegistration castDelegate = (ServletRegistration)delegate;
            return JakartaServletRegistrationAdapter.from(castDelegate);
        }
        if (delegate instanceof FilterRegistration) {
            FilterRegistration castDelegate = (FilterRegistration)delegate;
            return JakartaFilterRegistrationAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXRegistrationAdapter) {
            JavaXRegistrationAdapter castDelegate = (JavaXRegistrationAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaRegistrationAdapter::new);
    }

    protected JakartaRegistrationAdapter(javax.servlet.Registration delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.Registration getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getClassName() {
        return this.delegate.getClassName();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return this.delegate.setInitParameters(initParameters);
    }

    public Map<String, String> getInitParameters() {
        return this.delegate.getInitParameters();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

