/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaGenericServletAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXServletAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class JakartaServletAdapter
implements jakarta.servlet.Servlet,
Adapted<Servlet> {
    private final Servlet delegate;

    public static jakarta.servlet.Servlet from(Servlet delegate) {
        if (delegate instanceof GenericServlet) {
            GenericServlet castDelegate = (GenericServlet)delegate;
            return JakartaGenericServletAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXServletAdapter) {
            JavaXServletAdapter castDelegate = (JavaXServletAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletAdapter::new);
    }

    protected JakartaServletAdapter(Servlet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Servlet getDelegate() {
        return this.delegate;
    }

    public void init(ServletConfig servletConfig) throws jakarta.servlet.ServletException {
        try {
            this.delegate.init(JavaXAdapters.asJavaX(servletConfig));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return JakartaAdapters.asJakarta(this.delegate.getServletConfig());
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws jakarta.servlet.ServletException, IOException {
        try {
            this.delegate.service(JavaXAdapters.asJavaX(servletRequest), JavaXAdapters.asJavaX(servletResponse));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

