/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXServletConfigAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletConfig;

public class JakartaServletConfigAdapter
implements jakarta.servlet.ServletConfig,
Adapted<ServletConfig> {
    private final ServletConfig delegate;

    public static jakarta.servlet.ServletConfig from(ServletConfig delegate) {
        if (delegate instanceof JavaXServletConfigAdapter) {
            JavaXServletConfigAdapter castDelegate = (JavaXServletConfigAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletConfigAdapter::new);
    }

    protected JakartaServletConfigAdapter(ServletConfig delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ServletConfig getDelegate() {
        return this.delegate;
    }

    public String getServletName() {
        return this.delegate.getServletName();
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public String getInitParameter(String s) {
        return this.delegate.getInitParameter(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

