/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaDynamicFilterRegistrationAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaDynamicServletRegistrationAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterRegistrationAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaRequestDispatcherAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletRegistrationAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaSessionCookieConfigAdapter;
import io.atlassian.util.adapter.jakarta.servlet.descriptor.JakartaJspConfigDescriptorAdapter;
import io.atlassian.util.adapter.java.util.EnumerationAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletContextAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;

public class JakartaServletContextAdapter
implements ServletContext,
Adapted<javax.servlet.ServletContext> {
    private final javax.servlet.ServletContext delegate;

    public static ServletContext from(javax.servlet.ServletContext delegate) {
        if (delegate instanceof JavaXServletContextAdapter) {
            JavaXServletContextAdapter castDelegate = (JavaXServletContextAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletContextAdapter::new);
    }

    protected JakartaServletContextAdapter(javax.servlet.ServletContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.ServletContext getDelegate() {
        return this.delegate;
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return JakartaServletContextAdapter.from(this.delegate.getContext(uripath));
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.delegate.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.delegate.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.delegate.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return JakartaRequestDispatcherAdapter.from(this.delegate.getRequestDispatcher(path));
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return JakartaRequestDispatcherAdapter.from(this.delegate.getNamedDispatcher(name));
    }

    public Servlet getServlet(String name) throws jakarta.servlet.ServletException {
        try {
            return JakartaServletAdapter.from(this.delegate.getServlet(name));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public Enumeration<Servlet> getServlets() {
        Enumeration servlets = this.delegate.getServlets();
        if (servlets == null) {
            return null;
        }
        return new EnumerationAdapter<javax.servlet.Servlet, Servlet>(servlets, JakartaServletAdapter::from);
    }

    public Enumeration<String> getServletNames() {
        return this.delegate.getServletNames();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.delegate.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return JakartaAdapters.asJakartaIfJavaX(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegate.setAttribute(name, JavaXAdapters.asJavaXIfJakarta(object));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return JakartaDynamicServletRegistrationAdapter.from(this.delegate.addServlet(servletName, className));
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return JakartaDynamicServletRegistrationAdapter.from(this.delegate.addServlet(servletName, JavaXServletAdapter.from(servlet)));
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return JakartaDynamicServletRegistrationAdapter.from(this.delegate.addServlet(servletName, servletClass));
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return JakartaDynamicServletRegistrationAdapter.from(this.delegate.addJspFile(servletName, jspFile));
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)JakartaServletAdapter.from(this.delegate.createServlet(clazz));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return JakartaServletRegistrationAdapter.from(this.delegate.getServletRegistration(servletName));
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        Map servletRegistrations = this.delegate.getServletRegistrations();
        if (servletRegistrations == null) {
            return null;
        }
        return servletRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JakartaServletRegistrationAdapter.from((javax.servlet.ServletRegistration)e.getValue())));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return JakartaDynamicFilterRegistrationAdapter.from(this.delegate.addFilter(filterName, className));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return JakartaDynamicFilterRegistrationAdapter.from(this.delegate.addFilter(filterName, JavaXFilterAdapter.from(filter)));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return JakartaDynamicFilterRegistrationAdapter.from(this.delegate.addFilter(filterName, filterClass));
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)JakartaFilterAdapter.from(this.delegate.createFilter(clazz));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public jakarta.servlet.FilterRegistration getFilterRegistration(String filterName) {
        return JakartaFilterRegistrationAdapter.from(this.delegate.getFilterRegistration(filterName));
    }

    public Map<String, ? extends jakarta.servlet.FilterRegistration> getFilterRegistrations() {
        Map filterRegistrations = this.delegate.getFilterRegistrations();
        if (filterRegistrations == null) {
            return null;
        }
        return filterRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JakartaFilterRegistrationAdapter.from((FilterRegistration)e.getValue())));
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return JakartaSessionCookieConfigAdapter.from(this.delegate.getSessionCookieConfig());
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(JavaXServletContextAdapter.toJavaXSessionTrackingModeSet(sessionTrackingModes));
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return JakartaServletContextAdapter.toJakartaSessionTrackingModeSet(this.delegate.getDefaultSessionTrackingModes());
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return JakartaServletContextAdapter.toJakartaSessionTrackingModeSet(this.delegate.getEffectiveSessionTrackingModes());
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws jakarta.servlet.ServletException {
        try {
            return (T)this.delegate.createListener(clazz);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return JakartaJspConfigDescriptorAdapter.from(this.delegate.getJspConfigDescriptor());
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.delegate.getVirtualServerName();
    }

    public int getSessionTimeout() {
        return this.delegate.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.delegate.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.delegate.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.delegate.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.delegate.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.delegate.setResponseCharacterEncoding(encoding);
    }

    public static Set<SessionTrackingMode> toJakartaSessionTrackingModeSet(Collection<javax.servlet.SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes == null) {
            return null;
        }
        EnumSet<SessionTrackingMode> result = EnumSet.noneOf(SessionTrackingMode.class);
        for (javax.servlet.SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            result.add(SessionTrackingMode.valueOf((String)sessionTrackingMode.name()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

