/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaAsyncContextAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaRequestDispatcherAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletInputStreamAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletRequestWrapperAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletRequestAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXServletRequestAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;

public class JakartaServletRequestAdapter
implements jakarta.servlet.ServletRequest,
Adapted<ServletRequest> {
    private final ServletRequest delegate;

    public static jakarta.servlet.ServletRequest from(ServletRequest delegate) {
        if (delegate instanceof HttpServletRequest) {
            HttpServletRequest castDelegate = (HttpServletRequest)delegate;
            return JakartaHttpServletRequestAdapter.from(castDelegate);
        }
        if (delegate instanceof ServletRequestWrapper) {
            ServletRequestWrapper castDelegate = (ServletRequestWrapper)delegate;
            return JakartaServletRequestWrapperAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXServletRequestAdapter) {
            JavaXServletRequestAdapter castDelegate = (JavaXServletRequestAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaServletRequestAdapter::new);
    }

    protected JakartaServletRequestAdapter(ServletRequest delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ServletRequest getDelegate() {
        return this.delegate;
    }

    public Object getAttribute(String name) {
        return JakartaAdapters.asJakartaIfJavaX(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.delegate.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.delegate.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public long getContentLengthLong() {
        return this.delegate.getContentLengthLong();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return JakartaServletInputStreamAdapter.from(this.delegate.getInputStream());
    }

    public String getParameter(String name) {
        return this.delegate.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.delegate.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.delegate.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.delegate.getParameterMap();
    }

    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    public String getScheme() {
        return this.delegate.getScheme();
    }

    public String getServerName() {
        return this.delegate.getServerName();
    }

    public int getServerPort() {
        return this.delegate.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.delegate.getReader();
    }

    public String getRemoteAddr() {
        return this.delegate.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.delegate.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.delegate.setAttribute(name, JavaXAdapters.asJavaXIfJakarta(o));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.delegate.getLocales();
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return JakartaRequestDispatcherAdapter.from(this.delegate.getRequestDispatcher(path));
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public int getRemotePort() {
        return this.delegate.getRemotePort();
    }

    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    public String getLocalAddr() {
        return this.delegate.getLocalAddr();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return JakartaAsyncContextAdapter.from(this.delegate.startAsync());
    }

    public AsyncContext startAsync(jakarta.servlet.ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return JakartaAsyncContextAdapter.from(this.delegate.startAsync(JavaXAdapters.asJavaX(servletRequest), JavaXAdapters.asJavaX(servletResponse)));
    }

    public boolean isAsyncStarted() {
        return this.delegate.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.delegate.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return JakartaAsyncContextAdapter.from(this.delegate.getAsyncContext());
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.valueOf((String)this.delegate.getDispatcherType().name());
    }

    public String getRequestId() {
        return "";
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        return null;
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

