/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpServletAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletException;

public class JakartaHttpServletAdapter
extends HttpServlet
implements Adapted<javax.servlet.http.HttpServlet> {
    private final javax.servlet.http.HttpServlet delegate;

    public static HttpServlet from(javax.servlet.http.HttpServlet delegate) {
        if (delegate instanceof JavaXHttpServletAdapter) {
            JavaXHttpServletAdapter castDelegate = (JavaXHttpServletAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaHttpServletAdapter::new);
    }

    protected JakartaHttpServletAdapter(javax.servlet.http.HttpServlet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.http.HttpServlet getDelegate() {
        return this.delegate;
    }

    public void service(ServletRequest req, ServletResponse res) throws jakarta.servlet.ServletException, IOException {
        try {
            this.delegate.service(JavaXAdapters.asJavaX(req), JavaXAdapters.asJavaX(res));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getServletName() {
        return this.delegate.getServletName();
    }

    public void log(String message, Throwable t) {
        this.delegate.log(message, t);
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void init() throws jakarta.servlet.ServletException {
        try {
            this.delegate.init();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig config) throws jakarta.servlet.ServletException {
        try {
            this.delegate.init(JavaXAdapters.asJavaX(config));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public ServletConfig getServletConfig() {
        return JakartaAdapters.asJakarta(this.delegate.getServletConfig());
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

