/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet.http;

import io.atlassian.util.adapter.jakarta.servlet.JakartaServletRequestAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaCookieAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletMappingAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletRequestWrapperAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpSessionAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpUpgradeHandlerAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaPartAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaPushBuilderAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpServletRequestAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpServletResponseAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class JakartaHttpServletRequestAdapter
extends JakartaServletRequestAdapter
implements HttpServletRequest {
    private final javax.servlet.http.HttpServletRequest delegate;

    public static HttpServletRequest from(javax.servlet.http.HttpServletRequest delegate) {
        if (delegate instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper castDelegate = (HttpServletRequestWrapper)delegate;
            return JakartaHttpServletRequestWrapperAdapter.from(castDelegate);
        }
        if (delegate instanceof JavaXHttpServletRequestAdapter) {
            JavaXHttpServletRequestAdapter castDelegate = (JavaXHttpServletRequestAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaHttpServletRequestAdapter::new);
    }

    protected JakartaHttpServletRequestAdapter(javax.servlet.http.HttpServletRequest delegate) {
        super((ServletRequest)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.http.HttpServletRequest getDelegate() {
        return this.delegate;
    }

    public String getAuthType() {
        return this.delegate.getAuthType();
    }

    public Cookie[] getCookies() {
        javax.servlet.http.Cookie[] cookies = this.delegate.getCookies();
        if (cookies == null) {
            return null;
        }
        return (Cookie[])Arrays.stream(cookies).map(JakartaCookieAdapter::from).toArray(Cookie[]::new);
    }

    public long getDateHeader(String name) {
        return this.delegate.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.delegate.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.delegate.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.delegate.getIntHeader(name);
    }

    public HttpServletMapping getHttpServletMapping() {
        return JakartaHttpServletMappingAdapter.from(this.delegate.getHttpServletMapping());
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public String getPathInfo() {
        return this.delegate.getPathInfo();
    }

    public String getPathTranslated() {
        return this.delegate.getPathTranslated();
    }

    public PushBuilder newPushBuilder() {
        return JakartaPushBuilderAdapter.from(this.delegate.newPushBuilder());
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public String getQueryString() {
        return this.delegate.getQueryString();
    }

    public String getRemoteUser() {
        return this.delegate.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.delegate.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.delegate.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.delegate.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.delegate.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.delegate.getRequestURL();
    }

    public String getServletPath() {
        return this.delegate.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return JakartaHttpSessionAdapter.from(this.delegate.getSession(create));
    }

    public HttpSession getSession() {
        return JakartaHttpSessionAdapter.from(this.delegate.getSession());
    }

    public String changeSessionId() {
        return this.delegate.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.delegate.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.delegate.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.delegate.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.delegate.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, jakarta.servlet.ServletException {
        try {
            return this.delegate.authenticate(JavaXHttpServletResponseAdapter.from(response));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void login(String username, String password) throws jakarta.servlet.ServletException {
        try {
            this.delegate.login(username, password);
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public void logout() throws jakarta.servlet.ServletException {
        try {
            this.delegate.logout();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public Collection<Part> getParts() throws IOException, jakarta.servlet.ServletException {
        Collection parts;
        try {
            parts = this.delegate.getParts();
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
        return WrapperUtil.transformIfNonNull(parts, JakartaPartAdapter::from);
    }

    public Part getPart(String name) throws IOException, jakarta.servlet.ServletException {
        try {
            return JakartaPartAdapter.from(this.delegate.getPart(name));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, jakarta.servlet.ServletException {
        try {
            return (T)JakartaHttpUpgradeHandlerAdapter.from(this.delegate.upgrade(handlerClass));
        }
        catch (ServletException e) {
            throw new jakarta.servlet.ServletException((Throwable)e);
        }
    }

    public Map<String, String> getTrailerFields() {
        return this.delegate.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.delegate.isTrailerFieldsReady();
    }
}

