/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpSessionAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpSession;

public class JakartaHttpSessionAdapter
implements jakarta.servlet.http.HttpSession,
Adapted<HttpSession> {
    private final HttpSession delegate;

    public static jakarta.servlet.http.HttpSession from(HttpSession delegate) {
        if (delegate instanceof JavaXHttpSessionAdapter) {
            JavaXHttpSessionAdapter castDelegate = (JavaXHttpSessionAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaHttpSessionAdapter::new);
    }

    protected JakartaHttpSessionAdapter(HttpSession delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public HttpSession getDelegate() {
        return this.delegate;
    }

    public long getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public long getLastAccessedTime() {
        return this.delegate.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return JakartaAdapters.asJakarta(this.delegate.getServletContext());
    }

    public void setMaxInactiveInterval(int interval) {
        this.delegate.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.delegate.getMaxInactiveInterval();
    }

    public Object getAttribute(String name) {
        return JakartaAdapters.asJakartaIfJavaX(this.delegate.getAttribute(name));
    }

    public Object getValue(String name) {
        return JakartaAdapters.asJakartaIfJavaX(this.delegate.getValue(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public String[] getValueNames() {
        return this.delegate.getValueNames();
    }

    public void setAttribute(String name, Object value) {
        this.delegate.setAttribute(name, JavaXAdapters.asJavaXIfJakarta(value));
    }

    public void putValue(String name, Object value) {
        this.delegate.putValue(name, JavaXAdapters.asJavaXIfJakarta(value));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.delegate.removeAttribute(name);
    }

    public void invalidate() {
        this.delegate.invalidate();
    }

    public boolean isNew() {
        return this.delegate.isNew();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

