/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.jakarta.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletInputStreamAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletOutputStreamAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXWebConnectionAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.WebConnection;
import java.io.IOException;
import java.util.Objects;

public class JakartaWebConnectionAdapter
implements WebConnection,
Adapted<javax.servlet.http.WebConnection> {
    private final javax.servlet.http.WebConnection delegate;

    public static WebConnection from(javax.servlet.http.WebConnection delegate) {
        if (delegate instanceof JavaXWebConnectionAdapter) {
            JavaXWebConnectionAdapter castDelegate = (JavaXWebConnectionAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JakartaWebConnectionAdapter::new);
    }

    protected JakartaWebConnectionAdapter(javax.servlet.http.WebConnection delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public javax.servlet.http.WebConnection getDelegate() {
        return this.delegate;
    }

    public ServletInputStream getInputStream() throws IOException {
        return JakartaServletInputStreamAdapter.from(this.delegate.getInputStream());
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return JakartaServletOutputStreamAdapter.from(this.delegate.getOutputStream());
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

