/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaAsyncContextAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaAsyncListenerAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.AsyncContext;
import java.util.Objects;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXAsyncContextAdapter
implements javax.servlet.AsyncContext,
Adapted<AsyncContext> {
    private final AsyncContext delegate;

    public static javax.servlet.AsyncContext from(AsyncContext delegate) {
        if (delegate instanceof JakartaAsyncContextAdapter) {
            JakartaAsyncContextAdapter castDelegate = (JakartaAsyncContextAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXAsyncContextAdapter::new);
    }

    protected JavaXAsyncContextAdapter(AsyncContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public AsyncContext getDelegate() {
        return this.delegate;
    }

    public ServletRequest getRequest() {
        return JavaXAdapters.asJavaX(this.delegate.getRequest());
    }

    public ServletResponse getResponse() {
        return JavaXAdapters.asJavaX(this.delegate.getResponse());
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.delegate.hasOriginalRequestAndResponse();
    }

    public void dispatch() {
        this.delegate.dispatch();
    }

    public void dispatch(String path) {
        this.delegate.dispatch(path);
    }

    public void dispatch(ServletContext context, String path) {
        this.delegate.dispatch(JakartaAdapters.asJakarta(context), path);
    }

    public void complete() {
        this.delegate.complete();
    }

    public void start(Runnable run) {
        this.delegate.start(run);
    }

    public void addListener(AsyncListener listener) {
        this.delegate.addListener(JakartaAsyncListenerAdapter.from(listener));
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.delegate.addListener(JakartaAsyncListenerAdapter.from(listener), JakartaAdapters.asJakarta(servletRequest), JakartaAdapters.asJakarta(servletResponse));
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)this.delegate.createListener(clazz));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setTimeout(long timeout) {
        this.delegate.setTimeout(timeout);
    }

    public long getTimeout() {
        return this.delegate.getTimeout();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

