/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterChainAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterConfigAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXGenericFilterAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.GenericFilter;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXFilterAdapter
implements javax.servlet.Filter,
Adapted<Filter> {
    private final Filter delegate;

    public static javax.servlet.Filter from(Filter delegate) {
        if (delegate instanceof GenericFilter) {
            GenericFilter castDelegate = (GenericFilter)delegate;
            return JavaXGenericFilterAdapter.from(castDelegate);
        }
        if (delegate instanceof JakartaFilterAdapter) {
            JakartaFilterAdapter castDelegate = (JakartaFilterAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXFilterAdapter::new);
    }

    protected JavaXFilterAdapter(Filter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Filter getDelegate() {
        return this.delegate;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.delegate.init(JakartaFilterConfigAdapter.from(filterConfig));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.delegate.doFilter(JakartaAdapters.asJakarta(servletRequest), JakartaAdapters.asJakarta(servletResponse), JakartaFilterChainAdapter.from(filterChain));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

