/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXDynamicFilterRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXRegistrationAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Registration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import javax.servlet.FilterRegistration;

public class JavaXFilterRegistrationAdapter
extends JavaXRegistrationAdapter
implements FilterRegistration {
    private final jakarta.servlet.FilterRegistration delegate;

    public static FilterRegistration from(jakarta.servlet.FilterRegistration delegate) {
        if (delegate instanceof FilterRegistration.Dynamic) {
            FilterRegistration.Dynamic castDelegate = (FilterRegistration.Dynamic)delegate;
            return JavaXDynamicFilterRegistrationAdapter.from(castDelegate);
        }
        if (delegate instanceof JakartaFilterRegistrationAdapter) {
            JakartaFilterRegistrationAdapter castDelegate = (JakartaFilterRegistrationAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXFilterRegistrationAdapter::new);
    }

    protected JavaXFilterRegistrationAdapter(jakarta.servlet.FilterRegistration delegate) {
        super((Registration)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public jakarta.servlet.FilterRegistration getDelegate() {
        return this.delegate;
    }

    public void addMappingForServletNames(EnumSet<javax.servlet.DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        this.delegate.addMappingForServletNames(JavaXFilterRegistrationAdapter.toJakartaDispatcherTypeSet(dispatcherTypes), isMatchAfter, servletNames);
    }

    public Collection<String> getServletNameMappings() {
        return this.delegate.getServletNameMappings();
    }

    public void addMappingForUrlPatterns(EnumSet<javax.servlet.DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        this.delegate.addMappingForUrlPatterns(JavaXFilterRegistrationAdapter.toJakartaDispatcherTypeSet(dispatcherTypes), isMatchAfter, urlPatterns);
    }

    public Collection<String> getUrlPatternMappings() {
        return this.delegate.getUrlPatternMappings();
    }

    private static EnumSet<DispatcherType> toJakartaDispatcherTypeSet(Collection<javax.servlet.DispatcherType> dispatcherTypes) {
        if (dispatcherTypes == null) {
            return null;
        }
        EnumSet<DispatcherType> result = EnumSet.noneOf(DispatcherType.class);
        for (javax.servlet.DispatcherType dispatcherType : dispatcherTypes) {
            result.add(DispatcherType.valueOf((String)dispatcherType.name()));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    @Override
    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

