/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaGenericFilterAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpFilterAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.http.HttpFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.GenericFilter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXGenericFilterAdapter
extends GenericFilter
implements Adapted<jakarta.servlet.GenericFilter> {
    private final jakarta.servlet.GenericFilter delegate;

    public static GenericFilter from(jakarta.servlet.GenericFilter delegate) {
        if (delegate instanceof HttpFilter) {
            HttpFilter castDelegate = (HttpFilter)delegate;
            return JavaXHttpFilterAdapter.from(castDelegate);
        }
        if (delegate instanceof JakartaGenericFilterAdapter) {
            JakartaGenericFilterAdapter castDelegate = (JakartaGenericFilterAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXGenericFilterAdapter::new);
    }

    protected JavaXGenericFilterAdapter(jakarta.servlet.GenericFilter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public jakarta.servlet.GenericFilter getDelegate() {
        return this.delegate;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            this.delegate.doFilter(JakartaAdapters.asJakarta(req), JakartaAdapters.asJakarta(res), JakartaAdapters.asJakarta(chain));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public FilterConfig getFilterConfig() {
        return JavaXAdapters.asJavaX(this.delegate.getFilterConfig());
    }

    public ServletContext getServletContext() {
        return JavaXAdapters.asJavaX(this.delegate.getServletContext());
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            this.delegate.init(JakartaAdapters.asJakarta(config));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init() throws ServletException {
        try {
            this.delegate.init();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getFilterName() {
        return this.delegate.getFilterName();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

