/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXGenericServletAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.GenericServlet;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXServletAdapter
implements Servlet,
Adapted<jakarta.servlet.Servlet> {
    private final jakarta.servlet.Servlet delegate;

    public static Servlet from(jakarta.servlet.Servlet delegate) {
        if (delegate instanceof GenericServlet) {
            GenericServlet castDelegate = (GenericServlet)delegate;
            return JavaXGenericServletAdapter.from(castDelegate);
        }
        if (delegate instanceof JakartaServletAdapter) {
            JakartaServletAdapter castDelegate = (JakartaServletAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXServletAdapter::new);
    }

    protected JavaXServletAdapter(jakarta.servlet.Servlet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public jakarta.servlet.Servlet getDelegate() {
        return this.delegate;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.delegate.init(JakartaAdapters.asJakarta(servletConfig));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return JavaXAdapters.asJavaX(this.delegate.getServletConfig());
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.delegate.service(JakartaAdapters.asJakarta(servletRequest), JakartaAdapters.asJakarta(servletResponse));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

