/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaFilterAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletContextAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXDynamicFilterRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXDynamicServletRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXFilterRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXRequestDispatcherAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletRegistrationAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXSessionCookieConfigAdapter;
import io.atlassian.util.adapter.javax.servlet.descriptor.JavaXJspConfigDescriptorAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionTrackingMode;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.descriptor.JspConfigDescriptor;

public class JavaXServletContextAdapter
implements javax.servlet.ServletContext,
Adapted<ServletContext> {
    private final ServletContext delegate;

    public static javax.servlet.ServletContext from(ServletContext delegate) {
        if (delegate instanceof JakartaServletContextAdapter) {
            JakartaServletContextAdapter castDelegate = (JakartaServletContextAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXServletContextAdapter::new);
    }

    protected JavaXServletContextAdapter(ServletContext delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ServletContext getDelegate() {
        return this.delegate;
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public javax.servlet.ServletContext getContext(String uripath) {
        return JavaXServletContextAdapter.from(this.delegate.getContext(uripath));
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.delegate.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.delegate.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.delegate.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return JavaXRequestDispatcherAdapter.from(this.delegate.getRequestDispatcher(path));
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return JavaXRequestDispatcherAdapter.from(this.delegate.getNamedDispatcher(name));
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getServletNames() {
        return Collections.emptyEnumeration();
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return JavaXAdapters.asJavaXIfJakarta(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.delegate.setAttribute(name, JakartaAdapters.asJakartaIfJavaX(object));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return JavaXDynamicServletRegistrationAdapter.from(this.delegate.addServlet(servletName, className));
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return JavaXDynamicServletRegistrationAdapter.from(this.delegate.addServlet(servletName, JakartaServletAdapter.from(servlet)));
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return JavaXDynamicServletRegistrationAdapter.from(this.delegate.addServlet(servletName, servletClass));
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return JavaXDynamicServletRegistrationAdapter.from(this.delegate.addJspFile(servletName, jspFile));
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)JavaXServletAdapter.from(this.delegate.createServlet(clazz));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public javax.servlet.ServletRegistration getServletRegistration(String servletName) {
        return JavaXServletRegistrationAdapter.from(this.delegate.getServletRegistration(servletName));
    }

    public Map<String, ? extends javax.servlet.ServletRegistration> getServletRegistrations() {
        Map servletRegistrations = this.delegate.getServletRegistrations();
        if (servletRegistrations == null) {
            return null;
        }
        return servletRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JavaXServletRegistrationAdapter.from((ServletRegistration)e.getValue())));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return JavaXDynamicFilterRegistrationAdapter.from(this.delegate.addFilter(filterName, className));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return JavaXDynamicFilterRegistrationAdapter.from(this.delegate.addFilter(filterName, JakartaFilterAdapter.from(filter)));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return JavaXDynamicFilterRegistrationAdapter.from(this.delegate.addFilter(filterName, filterClass));
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)JavaXFilterAdapter.from(this.delegate.createFilter(clazz));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return JavaXFilterRegistrationAdapter.from(this.delegate.getFilterRegistration(filterName));
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        Map filterRegistrations = this.delegate.getFilterRegistrations();
        if (filterRegistrations == null) {
            return null;
        }
        return filterRegistrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JavaXFilterRegistrationAdapter.from((jakarta.servlet.FilterRegistration)e.getValue())));
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return JavaXSessionCookieConfigAdapter.from(this.delegate.getSessionCookieConfig());
    }

    public void setSessionTrackingModes(Set<javax.servlet.SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(JakartaServletContextAdapter.toJakartaSessionTrackingModeSet(sessionTrackingModes));
    }

    public Set<javax.servlet.SessionTrackingMode> getDefaultSessionTrackingModes() {
        return JavaXServletContextAdapter.toJavaXSessionTrackingModeSet(this.delegate.getDefaultSessionTrackingModes());
    }

    public Set<javax.servlet.SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return JavaXServletContextAdapter.toJavaXSessionTrackingModeSet(this.delegate.getEffectiveSessionTrackingModes());
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)this.delegate.createListener(clazz);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return JavaXJspConfigDescriptorAdapter.from(this.delegate.getJspConfigDescriptor());
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.delegate.getVirtualServerName();
    }

    public int getSessionTimeout() {
        return this.delegate.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.delegate.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.delegate.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.delegate.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.delegate.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.delegate.setResponseCharacterEncoding(encoding);
    }

    public static Set<javax.servlet.SessionTrackingMode> toJavaXSessionTrackingModeSet(Collection<SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes == null) {
            return null;
        }
        EnumSet<javax.servlet.SessionTrackingMode> result = EnumSet.noneOf(javax.servlet.SessionTrackingMode.class);
        for (SessionTrackingMode sessionTrackingMode : sessionTrackingModes) {
            result.add(javax.servlet.SessionTrackingMode.valueOf((String)sessionTrackingMode.name()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

