/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletOutputStreamAdapter;
import io.atlassian.util.adapter.jakarta.servlet.JakartaWriteListenerAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.WriteListener;

public class JavaXServletOutputStreamAdapter
extends javax.servlet.ServletOutputStream
implements Adapted<ServletOutputStream> {
    private final ServletOutputStream delegate;

    public static javax.servlet.ServletOutputStream from(ServletOutputStream delegate) {
        if (delegate instanceof JakartaServletOutputStreamAdapter) {
            JakartaServletOutputStreamAdapter castDelegate = (JakartaServletOutputStreamAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXServletOutputStreamAdapter::new);
    }

    protected JavaXServletOutputStreamAdapter(ServletOutputStream delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ServletOutputStream getDelegate() {
        return this.delegate;
    }

    public void print(String s) throws IOException {
        this.delegate.print(s);
    }

    public void print(boolean b) throws IOException {
        this.delegate.print(b);
    }

    public void print(char c) throws IOException {
        this.delegate.print(c);
    }

    public void print(int i) throws IOException {
        this.delegate.print(i);
    }

    public void print(long l) throws IOException {
        this.delegate.print(l);
    }

    public void print(float f) throws IOException {
        this.delegate.print(f);
    }

    public void print(double d) throws IOException {
        this.delegate.print(d);
    }

    public void println() throws IOException {
        this.delegate.println();
    }

    public void println(String s) throws IOException {
        this.delegate.println(s);
    }

    public void println(boolean b) throws IOException {
        this.delegate.println(b);
    }

    public void println(char c) throws IOException {
        this.delegate.println(c);
    }

    public void println(int i) throws IOException {
        this.delegate.println(i);
    }

    public void println(long l) throws IOException {
        this.delegate.println(l);
    }

    public void println(float f) throws IOException {
        this.delegate.println(f);
    }

    public void println(double d) throws IOException {
        this.delegate.println(d);
    }

    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.delegate.setWriteListener(JakartaWriteListenerAdapter.from(writeListener));
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

