/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.JakartaServletRequestAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.JavaXAsyncContextAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXRequestDispatcherAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletInputStreamAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletRequestWrapperAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpServletRequestAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXServletRequestAdapter
implements ServletRequest,
Adapted<jakarta.servlet.ServletRequest> {
    private final jakarta.servlet.ServletRequest delegate;

    public static ServletRequest from(jakarta.servlet.ServletRequest delegate) {
        if (delegate instanceof HttpServletRequest) {
            HttpServletRequest castDelegate = (HttpServletRequest)delegate;
            return JavaXHttpServletRequestAdapter.from(castDelegate);
        }
        if (delegate instanceof ServletRequestWrapper) {
            ServletRequestWrapper castDelegate = (ServletRequestWrapper)delegate;
            return JavaXServletRequestWrapperAdapter.from(castDelegate);
        }
        if (delegate instanceof JakartaServletRequestAdapter) {
            JakartaServletRequestAdapter castDelegate = (JakartaServletRequestAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXServletRequestAdapter::new);
    }

    protected JavaXServletRequestAdapter(jakarta.servlet.ServletRequest delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public jakarta.servlet.ServletRequest getDelegate() {
        return this.delegate;
    }

    public Object getAttribute(String name) {
        return JavaXAdapters.asJavaXIfJakarta(this.delegate.getAttribute(name));
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.delegate.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.delegate.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public long getContentLengthLong() {
        return this.delegate.getContentLengthLong();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return JavaXServletInputStreamAdapter.from(this.delegate.getInputStream());
    }

    public String getParameter(String name) {
        return this.delegate.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.delegate.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.delegate.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.delegate.getParameterMap();
    }

    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    public String getScheme() {
        return this.delegate.getScheme();
    }

    public String getServerName() {
        return this.delegate.getServerName();
    }

    public int getServerPort() {
        return this.delegate.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.delegate.getReader();
    }

    public String getRemoteAddr() {
        return this.delegate.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.delegate.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.delegate.setAttribute(name, JakartaAdapters.asJakartaIfJavaX(o));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.delegate.getLocales();
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return JavaXRequestDispatcherAdapter.from(this.delegate.getRequestDispatcher(path));
    }

    public String getRealPath(String path) {
        return this.delegate.getServletContext().getRealPath(path);
    }

    public int getRemotePort() {
        return this.delegate.getRemotePort();
    }

    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    public String getLocalAddr() {
        return this.delegate.getLocalAddr();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public ServletContext getServletContext() {
        return JavaXAdapters.asJavaX(this.delegate.getServletContext());
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return JavaXAsyncContextAdapter.from(this.delegate.startAsync());
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return JavaXAsyncContextAdapter.from(this.delegate.startAsync(JakartaAdapters.asJakarta(servletRequest), JakartaAdapters.asJakarta(servletResponse)));
    }

    public boolean isAsyncStarted() {
        return this.delegate.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.delegate.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return JavaXAsyncContextAdapter.from(this.delegate.getAsyncContext());
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.valueOf((String)this.delegate.getDispatcherType().name());
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

