/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpFilterAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.util.WrapperUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;

public class JavaXHttpFilterAdapter
extends HttpFilter
implements Adapted<jakarta.servlet.http.HttpFilter> {
    private final jakarta.servlet.http.HttpFilter delegate;

    public static HttpFilter from(jakarta.servlet.http.HttpFilter delegate) {
        if (delegate instanceof JakartaHttpFilterAdapter) {
            JakartaHttpFilterAdapter castDelegate = (JakartaHttpFilterAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXHttpFilterAdapter::new);
    }

    protected JavaXHttpFilterAdapter(jakarta.servlet.http.HttpFilter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public jakarta.servlet.http.HttpFilter getDelegate() {
        return this.delegate;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            this.delegate.doFilter(JakartaAdapters.asJakarta(req), JakartaAdapters.asJakarta(res), JakartaAdapters.asJakarta(chain));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public FilterConfig getFilterConfig() {
        return JavaXAdapters.asJavaX(this.delegate.getFilterConfig());
    }

    public ServletContext getServletContext() {
        return JavaXAdapters.asJavaX(this.delegate.getServletContext());
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            this.delegate.init(JakartaAdapters.asJakarta(config));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init() throws ServletException {
        try {
            this.delegate.init();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getFilterName() {
        return this.delegate.getFilterName();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

