/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JavaXHttpServletAdapter
extends javax.servlet.http.HttpServlet
implements Adapted<HttpServlet> {
    private final HttpServlet delegate;

    public static javax.servlet.http.HttpServlet from(HttpServlet delegate) {
        if (delegate instanceof JakartaHttpServletAdapter) {
            JakartaHttpServletAdapter castDelegate = (JakartaHttpServletAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXHttpServletAdapter::new);
    }

    protected JavaXHttpServletAdapter(HttpServlet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public HttpServlet getDelegate() {
        return this.delegate;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        try {
            this.delegate.service(JakartaAdapters.asJakarta(req), JakartaAdapters.asJakarta(res));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getServletName() {
        return this.delegate.getServletName();
    }

    public void log(String message, Throwable t) {
        this.delegate.log(message, t);
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void init() throws ServletException {
        try {
            this.delegate.init();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.delegate.init(JakartaAdapters.asJakarta(config));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public ServletContext getServletContext() {
        return JavaXAdapters.asJavaX(this.delegate.getServletContext());
    }

    public ServletConfig getServletConfig() {
        return JavaXAdapters.asJavaX(this.delegate.getServletConfig());
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

