/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet.http;

import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletRequestAdapter;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpServletResponseAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletRequestAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXCookieAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpServletMappingAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpServletRequestWrapperAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpSessionAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpUpgradeHandlerAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXPartAdapter;
import io.atlassian.util.adapter.javax.servlet.http.JavaXPushBuilderAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.servlet.http.PushBuilder;

public class JavaXHttpServletRequestAdapter
extends JavaXServletRequestAdapter
implements javax.servlet.http.HttpServletRequest {
    private final HttpServletRequest delegate;

    public static javax.servlet.http.HttpServletRequest from(HttpServletRequest delegate) {
        if (delegate instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper castDelegate = (HttpServletRequestWrapper)delegate;
            return JavaXHttpServletRequestWrapperAdapter.from(castDelegate);
        }
        if (delegate instanceof JakartaHttpServletRequestAdapter) {
            JakartaHttpServletRequestAdapter castDelegate = (JakartaHttpServletRequestAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXHttpServletRequestAdapter::new);
    }

    protected JavaXHttpServletRequestAdapter(HttpServletRequest delegate) {
        super((ServletRequest)delegate);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public HttpServletRequest getDelegate() {
        return this.delegate;
    }

    public String getAuthType() {
        return this.delegate.getAuthType();
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Cookie[] cookies = this.delegate.getCookies();
        if (cookies == null) {
            return null;
        }
        return (javax.servlet.http.Cookie[])Arrays.stream(cookies).map(JavaXCookieAdapter::from).toArray(javax.servlet.http.Cookie[]::new);
    }

    public long getDateHeader(String name) {
        return this.delegate.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.delegate.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.delegate.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.delegate.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.delegate.getIntHeader(name);
    }

    public HttpServletMapping getHttpServletMapping() {
        return JavaXHttpServletMappingAdapter.from(this.delegate.getHttpServletMapping());
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public String getPathInfo() {
        return this.delegate.getPathInfo();
    }

    public String getPathTranslated() {
        return this.delegate.getPathTranslated();
    }

    public PushBuilder newPushBuilder() {
        return JavaXPushBuilderAdapter.from(this.delegate.newPushBuilder());
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public String getQueryString() {
        return this.delegate.getQueryString();
    }

    public String getRemoteUser() {
        return this.delegate.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.delegate.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.delegate.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.delegate.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.delegate.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.delegate.getRequestURL();
    }

    public String getServletPath() {
        return this.delegate.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return JavaXHttpSessionAdapter.from(this.delegate.getSession(create));
    }

    public HttpSession getSession() {
        return JavaXHttpSessionAdapter.from(this.delegate.getSession());
    }

    public String changeSessionId() {
        return this.delegate.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.delegate.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.delegate.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.delegate.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        try {
            return this.delegate.authenticate(JakartaHttpServletResponseAdapter.from(response));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void login(String username, String password) throws ServletException {
        try {
            this.delegate.login(username, password);
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void logout() throws ServletException {
        try {
            this.delegate.logout();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        Collection parts;
        try {
            parts = this.delegate.getParts();
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
        return WrapperUtil.transformIfNonNull(parts, JavaXPartAdapter::from);
    }

    public Part getPart(String name) throws IOException, ServletException {
        try {
            return JavaXPartAdapter.from(this.delegate.getPart(name));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        try {
            return (T)JavaXHttpUpgradeHandlerAdapter.from(this.delegate.upgrade(handlerClass));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Map<String, String> getTrailerFields() {
        return this.delegate.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return this.delegate.isTrailerFieldsReady();
    }
}

