/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaHttpSessionAdapter;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import io.atlassian.util.adapter.javax.servlet.http.JavaXHttpSessionContextAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class JavaXHttpSessionAdapter
implements HttpSession,
Adapted<jakarta.servlet.http.HttpSession> {
    private final jakarta.servlet.http.HttpSession delegate;

    public static HttpSession from(jakarta.servlet.http.HttpSession delegate) {
        if (delegate instanceof JakartaHttpSessionAdapter) {
            JakartaHttpSessionAdapter castDelegate = (JakartaHttpSessionAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXHttpSessionAdapter::new);
    }

    protected JavaXHttpSessionAdapter(jakarta.servlet.http.HttpSession delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public jakarta.servlet.http.HttpSession getDelegate() {
        return this.delegate;
    }

    public long getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public long getLastAccessedTime() {
        return this.delegate.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return JavaXAdapters.asJavaX(this.delegate.getServletContext());
    }

    public void setMaxInactiveInterval(int interval) {
        this.delegate.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.delegate.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return JavaXHttpSessionContextAdapter.INSTANCE;
    }

    public Object getAttribute(String name) {
        return JavaXAdapters.asJavaXIfJakarta(this.delegate.getAttribute(name));
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public String[] getValueNames() {
        return WrapperUtil.enumerationToArray(this.getAttributeNames(), String.class);
    }

    public void setAttribute(String name, Object value) {
        this.delegate.setAttribute(name, JakartaAdapters.asJakartaIfJavaX(value));
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, JakartaAdapters.asJakartaIfJavaX(value));
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.delegate.removeAttribute(name);
    }

    public void invalidate() {
        this.delegate.invalidate();
    }

    public boolean isNew() {
        return this.delegate.isNew();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

