/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.util.adapter.javax.servlet.http;

import io.atlassian.util.adapter.Adapted;
import io.atlassian.util.adapter.jakarta.servlet.http.JakartaWebConnectionAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletInputStreamAdapter;
import io.atlassian.util.adapter.javax.servlet.JavaXServletOutputStreamAdapter;
import io.atlassian.util.adapter.util.WrapperUtil;
import jakarta.servlet.http.WebConnection;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;

public class JavaXWebConnectionAdapter
implements javax.servlet.http.WebConnection,
Adapted<WebConnection> {
    private final WebConnection delegate;

    public static javax.servlet.http.WebConnection from(WebConnection delegate) {
        if (delegate instanceof JakartaWebConnectionAdapter) {
            JakartaWebConnectionAdapter castDelegate = (JakartaWebConnectionAdapter)delegate;
            return castDelegate.getDelegate();
        }
        return WrapperUtil.applyIfNonNull(delegate, JavaXWebConnectionAdapter::new);
    }

    protected JavaXWebConnectionAdapter(WebConnection delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public WebConnection getDelegate() {
        return this.delegate;
    }

    public ServletInputStream getInputStream() throws IOException {
        return JavaXServletInputStreamAdapter.from(this.delegate.getInputStream());
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return JavaXServletOutputStreamAdapter.from(this.delegate.getOutputStream());
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    public boolean equals(Object obj) {
        return WrapperUtil.equals(this, obj);
    }

    public int hashCode() {
        return WrapperUtil.hashCode(this);
    }
}

