/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.atlassian.plugins.whitelist.ui.WhitelistBean;
import com.atlassian.plugins.whitelist.ui.WhitelistBeanService;
import com.atlassian.plugins.whitelist.ui.WhitelistRuleComparator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhitelistBeanServiceImpl
implements WhitelistBeanService {
    private static final Logger logger = LoggerFactory.getLogger(WhitelistBeanServiceImpl.class);
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private final WhitelistService whitelistService;
    private final WhitelistRuleComparator whitelistRuleComparator;
    private final Map<WhitelistType, Function<WhitelistRule, WhitelistBean>> mappings = Map.of(WhitelistType.APPLICATION_LINK, this.createApplicationLinkRule(), WhitelistType.EXACT_URL, this.createUrlExpressionRule(), WhitelistType.WILDCARD_EXPRESSION, this.createUrlExpressionRule(), WhitelistType.REGULAR_EXPRESSION, this.createUrlExpressionRule(), WhitelistType.DOMAIN_NAME, this.createUrlExpressionRule());

    public WhitelistBeanServiceImpl(ReadOnlyApplicationLinkService applicationLinkService, WhitelistService whitelistService, WhitelistRuleComparator whitelistRuleComparator) {
        this.applicationLinkService = applicationLinkService;
        this.whitelistService = whitelistService;
        this.whitelistRuleComparator = whitelistRuleComparator;
    }

    @Override
    public WhitelistBean add(WhitelistBean whitelistBean) {
        return this.asBean(this.whitelistService.add(whitelistBean.asRule()));
    }

    @Override
    public WhitelistBean update(int id, WhitelistBean whitelistBean) {
        WhitelistRule existingWhitelistRule = this.whitelistService.get(id);
        Objects.requireNonNull(existingWhitelistRule, "Whitelist rule with id '" + id + "' not existing.");
        WhitelistRule updatedRule = whitelistBean.populateWith(existingWhitelistRule);
        WhitelistRule whitelistRule = this.whitelistService.update(updatedRule);
        return this.asBean(whitelistRule);
    }

    @Override
    public List<WhitelistBean> getAll() {
        return this.asBeans(this.whitelistService.getAll().stream().sorted(this.whitelistRuleComparator).toList());
    }

    private List<WhitelistBean> asBeans(List<WhitelistRule> whitelistRules) {
        return whitelistRules.stream().map(this.asBean()).filter(Objects::nonNull).toList();
    }

    private WhitelistBean asBean(WhitelistRule whitelistRule) {
        Objects.requireNonNull(whitelistRule, "whitelistRule");
        WhitelistType type = whitelistRule.getType();
        Function<WhitelistRule, WhitelistBean> whitelistRuleDataWhitelistBeanFunction = this.mappings.get(type);
        if (whitelistRuleDataWhitelistBeanFunction == null) {
            logger.warn("No mapping found for whitelist type '{}', ignoring data '{}'.", (Object)type, (Object)whitelistRule);
            return null;
        }
        return whitelistRuleDataWhitelistBeanFunction.apply(whitelistRule);
    }

    private Function<WhitelistRule, WhitelistBean> asBean() {
        return input -> Optional.ofNullable(input).map(this::asBean).orElse(null);
    }

    private Function<WhitelistRule, WhitelistBean> createApplicationLinkRule() {
        return input -> {
            String applicationId = input.getExpression();
            ReadOnlyApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId));
            if (applicationLink == null) {
                logger.warn("Failed to resolved application link with application id '{}'; maybe it has been removed and the whitelist was not updated?", (Object)applicationId);
                return null;
            }
            String applicationLinkName = applicationLink.getName();
            URI displayUrl = applicationLink.getDisplayUrl();
            URI iconUrl = applicationLink.getType().getIconUrl();
            return WhitelistBean.builder().id(input.getId()).expression(String.format("%s (%s)", applicationLinkName, displayUrl.toString())).type(WhitelistType.APPLICATION_LINK).iconUrl(iconUrl != null ? iconUrl.toString() : "").allowInbound(input.isAllowInbound()).allowAnonymousUser(!input.isAuthenticationRequired()).build();
        };
    }

    private Function<WhitelistRule, WhitelistBean> createUrlExpressionRule() {
        return input -> WhitelistBean.builder().from((WhitelistRule)input).iconUrl(this.generateIconUrl((WhitelistRule)input, "")).build();
    }

    private String generateIconUrl(WhitelistRule whitelistRule, String defaultIconUrl) {
        if (whitelistRule.getType() == WhitelistType.EXACT_URL || whitelistRule.getType() == WhitelistType.DOMAIN_NAME) {
            return this.generateFavIconUrl(whitelistRule.getExpression(), defaultIconUrl);
        }
        return defaultIconUrl;
    }

    private String generateFavIconUrl(String expression, String defaultIconUrl) {
        try {
            URI uri = new URI(expression);
            return uri.getScheme() + "://" + uri.getAuthority() + "/favicon.ico";
        }
        catch (URISyntaxException e) {
            return defaultIconUrl;
        }
    }
}

