/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.ui;

import com.atlassian.plugins.whitelist.WhitelistType;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WhitelistTypeMapper {
    private static final Map<String, WhitelistType> whitelistTypeMap = Stream.of(WhitelistType.values()).collect(Collectors.toUnmodifiableMap(WhitelistTypeMapper::asString, t -> t));

    public static String asString(WhitelistType whitelistType) {
        Objects.requireNonNull(whitelistType, "whitelistType");
        return "whitelist." + whitelistType.name().toLowerCase().replace('_', '.');
    }

    public static WhitelistType asType(String value) {
        Objects.requireNonNull(value, "value");
        WhitelistType whitelistType = whitelistTypeMap.get(value);
        Preconditions.checkArgument((whitelistType != null ? 1 : 0) != 0, (Object)("Failed to find a matching whitelist type mapping for the given string '" + value + "'; known types are: " + String.valueOf(whitelistTypeMap.keySet())));
        return whitelistType;
    }
}

