/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.plugin.onboarding.rest.v1;

import com.atlassian.audit.plugin.onboarding.OnboardingSeenService;
import com.atlassian.audit.rest.model.ResponseErrorJson;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;

@OpenAPIDefinition(info=@Info(title="Audit Onboarding", version="1.0.0", description="This is the onboarding API. The root path is /rest/auditing/1.0"))
@LicensedOnly
@Path(value="/onboarding")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OnboardingRestResource {
    private final OnboardingSeenService onboardingSeenService;

    @Inject
    public OnboardingRestResource(OnboardingSeenService onboardingSeenService) {
        this.onboardingSeenService = onboardingSeenService;
    }

    @PUT
    @Path(value="/dismiss")
    @Operation(summary="Dismiss the onboarding so it will not show again in any version in the future.", tags={"audit", "onboarding"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation"), @ApiResponse(responseCode="400", description="Bad request", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ResponseErrorJson.class)))}), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response dismissedOnboarding(@Context SecurityContext securityContext) {
        this.onboardingSeenService.seenAndDismissed();
        return Response.ok().build();
    }
}

