/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.retention;

import com.atlassian.audit.api.AuditRetentionConfig;
import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.audit.rest.v1.validation.exception.AuthorisationException;
import javax.annotation.Nonnull;

public class RestrictiveRetentionConfigService
implements AuditRetentionConfigService {
    private final PermissionChecker permissionChecker;
    private final AuditRetentionConfigService origin;

    public RestrictiveRetentionConfigService(PermissionChecker permissionChecker, AuditRetentionConfigService origin) {
        this.permissionChecker = permissionChecker;
        this.origin = origin;
    }

    @Nonnull
    public AuditRetentionConfig getConfig() {
        if (!this.permissionChecker.hasRetentionConfigViewPermission()) {
            throw new AuthorisationException("The user is not allowed to view audit retention configuration");
        }
        return this.origin.getConfig();
    }

    public void updateConfig(@Nonnull AuditRetentionConfig config) {
        if (!this.permissionChecker.hasRetentionConfigUpdatePermission()) {
            throw new AuthorisationException("The user is not allowed to update audit retention configuration");
        }
        this.origin.updateConfig(config);
    }
}

