/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.admin;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.plugin.notifications.admin.AbstractAdminServlet;
import com.atlassian.plugin.notifications.api.medium.NotificationMedium;
import com.atlassian.plugin.notifications.module.NotificationMediumManager;
import com.atlassian.plugin.notifications.spi.salext.GroupManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Qualifier;

@SystemAdminOnly
public class AddServerServlet
extends AbstractAdminServlet {
    private final NotificationMediumManager notificationMediumManager;
    private final I18nResolver i18n;
    private final GroupManager groupManager;

    public AddServerServlet(WebSudoManager webSudoManager, TemplateRenderer renderer, UserManager userManager, LoginUriProvider loginUriProvider, WebResourceManager webResourceManager, NotificationMediumManager notificationMediumManager, @Qualifier(value="i18nResolver") I18nResolver i18n, GroupManager groupManager) {
        super(webSudoManager, renderer, userManager, loginUriProvider, webResourceManager);
        this.notificationMediumManager = notificationMediumManager;
        this.i18n = i18n;
        this.groupManager = groupManager;
    }

    @Override
    protected void requireResource(WebResourceManager webResourceManager) {
        webResourceManager.requireResource("com.atlassian.plugin.notifications.notifications-module:notification-server");
    }

    @Override
    protected void renderResponse(TemplateRenderer renderer, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<NotificationMedium> notificationMediums = this.notificationMediumManager.getNotificationMediums().stream().sorted(new Comparator<NotificationMedium>(){

            @Override
            public int compare(NotificationMedium medium1, NotificationMedium medium2) {
                String medium1Name = AddServerServlet.this.notificationMediumManager.getI18nizedMediumName(AddServerServlet.this.i18n, medium1.getKey());
                String medium2Name = AddServerServlet.this.notificationMediumManager.getI18nizedMediumName(AddServerServlet.this.i18n, medium2.getKey());
                return medium1Name.compareTo(medium2Name);
            }
        }).filter(medium -> !medium.staticConfiguration().isPresent()).toList();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("notificationMediums", notificationMediums);
        context.put("groups", StreamSupport.stream(this.groupManager.getGroups().spliterator(), false).toList());
        context.put("notificationMediumManager", this.notificationMediumManager);
        renderer.render("templates/admin/addnotificationserver.vm", context, (Writer)response.getWriter());
    }
}

