/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.admin;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.plugin.notifications.admin.AbstractAdminServlet;
import com.atlassian.plugin.notifications.config.ServerConfigurationManager;
import com.atlassian.plugin.notifications.module.NotificationMediumManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.stream.StreamSupport;

@SystemAdminOnly
public class ViewServersServlet
extends AbstractAdminServlet {
    private final ServerConfigurationManager serverConfigurationManager;
    private final NotificationMediumManager notificationMediumManager;

    public ViewServersServlet(WebSudoManager webSudoManager, TemplateRenderer renderer, UserManager userManager, LoginUriProvider loginUriProvider, WebResourceManager webResourceManager, ServerConfigurationManager serverConfigurationManager, NotificationMediumManager notificationMediumManager) {
        super(webSudoManager, renderer, userManager, loginUriProvider, webResourceManager);
        this.serverConfigurationManager = serverConfigurationManager;
        this.notificationMediumManager = notificationMediumManager;
    }

    @Override
    protected void requireResource(WebResourceManager webResourceManager) {
        webResourceManager.requireResource("com.atlassian.plugin.notifications.notifications-module:notification-server");
    }

    @Override
    protected void renderResponse(TemplateRenderer renderer, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("status", this.serverConfigurationManager.getNotificationStatus());
        context.put("servers", StreamSupport.stream(this.serverConfigurationManager.getServers().spliterator(), false).toList());
        context.put("notificationMediumManager", this.notificationMediumManager);
        renderer.render("templates/admin/view-notification-servers.vm", context, (Writer)response.getWriter());
    }
}

